/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xfirm.h
 *       common declarations for firmware and CAPI
 * -----------------------------------------------------------------*/

 /*
   Note:

   You should never need to incude this file yourself. Include typedefs.h
   for CAPI or std_types.h for firmware instead.
*/


#ifndef XFIRMWARE_H_INCLUDED
#define XFIRMWARE_H_INCLUDED


#ifndef XTYPEDEFS_H_INCLUDED
#  ifndef __STD_TYPES_H

   You should not include this file by yourself

#  endif
#endif


/* The kind of communication ports the Host talks to the BEST */
#ifdef CUSTOM_OEM1
typedef enum {
  BX_PORT_RS232,
  BX_PORT_PARALLEL,
  BX_PORT_FASTHIF,
  BX_PORT_PCI_CONF,
  BX_PORT_PCI_IO,
  BX_PORT_USB,
#ifdef CUSTOM_OEM1
  BX_PORT_OEM,
#endif
  BX_PORT_OFFLINE,
  BX_PORT_PRODUCTION,
  BX_PORT_COUNT,        /* for internal use only */
  BX_PORT_CURRENT,
  BX_PORT_UNKNOWN=255   /* for svp use */
} bx_porttype;

typedef enum {
    BX_PORTID_UNKNOWN,
    BX_PORTID_DEBUG,   /* NEVER (EVER) change the index of BX_PORTID_DEBUG !! */
    BX_PORTID_SERIAL,
    BX_PORTID_PARALLEL,
    BX_PORTID_PCI,
    BX_PORTID_USB,
#ifdef CUSTOM_OEM1
    BX_PORTID_OEM,
#endif
    BX_PORTID_LAN,
    BX_PORTID_COUNT
} BX_PORTID;

#else

CLI typedef enum {
  BX_PORT_RS232,
  BX_PORT_PARALLEL,
  BX_PORT_FASTHIF,
  BX_PORT_PCI_CONF,
  BX_PORT_PCI_IO,
  BX_PORT_USB,
  BX_PORT_OFFLINE,
  BX_PORT_PRODUCTION,
  BX_PORT_COUNT,        /* for internal use only */
  BX_PORT_CURRENT,
  BX_PORT_UNKNOWN=255   /* for svp use */
} bx_porttype;

/* The firmware view */
/* !! NOTE: keep the BX_PORTID enum coherent with port list in error.c (CAPI) */
/* !! ALSO; these enums are used as indexes into the Port Regfile 0x10 */

typedef enum {
    BX_PORTID_UNKNOWN,
    BX_PORTID_DEBUG,   /* NEVER (EVER) change the index of BX_PORTID_DEBUG !! */
    BX_PORTID_SERIAL,
    BX_PORTID_PARALLEL,
    BX_PORTID_PCI,
    BX_PORTID_USB,
    BX_PORTID_LAN,
    BX_PORTID_COUNT
} BX_PORTID;
#endif

/* the pattern strings are classified into several pattern areas (xpattdef.c) */
#define BX_PATTM_NONE              0x0  /* not shown in GUI pattern editor */
#define BX_PATTM_TRIG              0x1  /* available in trigger pattern editor */ 
#define BX_PATTM_SQ                0x2  /* available in storage pattern editor */ 
#define BX_PATTM_COND              0x4  /* available in conditional start pattern editor */ 
#define BX_PATTM_TRIGOBS           0x8  /* available in trigger observer pattern editor */ 
#define BX_PATTM_ERR               0x10 /* available in trigger sequence pattern editor  */ 

/* ---------------------------------------------------------------
   definitions for error handling
   --------------------------------------------------------------- */

#define BX_ERROR_MSGLENGTH    1024
#define BX_LASTERR_STRING     256

#ifndef SWIG
typedef struct {
  char            lasterr_msg [BX_ERROR_MSGLENGTH];
  char        lasterr_str [BX_LASTERR_STRING];
  bx_errtype     lasterr_err;

#if defined (BEST_FIRMWARE) || defined (CORE_FIRMWARE) 
  ULONG       lasterr_par [BX_ERROR_NUMPARAMS];
  
#else
  bx_int64    lasterr_par [BX_ERROR_NUMPARAMS];
  
#endif
  
} bx_lasterrtype;
#endif

/* --------------------------------------------------------------
   definitions for string lists (pattern parser)
   -------------------------------------------------------------- */
#ifndef SWIG
typedef struct {       /* some parameters do have a list of strings as value */
  char *          name;  /* e.g.: lock, unlock, releaselock etc              */
  unsigned long   value;    /* and is represented by this value              */
} bx_param_stringlisttype; 
#endif


/* --------------------------------------------------------------
   definitions for card communication
   -------------------------------------------------------------- */

/* communcation purposes */
#define BX_LENGTH_NEGOTIATE        0xffff


/* --------------------------------------------------------------
   definitions for license handling
   -------------------------------------------------------------- */

/* license codes */
/* codes for scalable resources */

/* !! NOTE !!
   The list of licenses in error.c is related to the bit position in the
   license field. Keep them coherent! */

CLI            /* DEF_START ~G_BX_Capability */
#define BX_CAPABILITY_SIZE              4 /* this is the real number of capa's */
                                          /* that are: EXERCISER, ANALYZER,    */
                                          /*           PERFORMANCE, OBSERVER   */
                                          /* need in firmware for watchtasks   */
#define BX_CAPABILITY_NONE                 0x00000000UL   /* @capnone */
#define BX_CAPABILITY_ALL                  0xfffff800UL   /* @capall  last byte for h/w */
#define BX_CAPABILITY_HARDWARE_MASK        0x000000ffUL   /* reserved */


/* codes for ASIC resources */
#define BX_CAPABILITY_PERFORMANCE          0x00001000UL
#define BX_CAPABILITY_OBSERVER             0x00002000UL
#define BX_CAPABILITY_CAPI                 0x00010000UL 
#define BX_CAPABILITY_ANALYZER             0x00020000UL
#define BX_CAPABILITY_EXERCISER            0x00040000UL

/* */
#define BX_CAPABILITY_64_BIT               0x00100000UL

/* codes for additional excecution engines */
#define BX_CAPABILITY_RESIDENT            0x80000000UL

CLI                /* DEF_END */

/* locking classes */

/* --------------------------------------------------------------------------
 * bx_blockiorestype defines those onboard resources that can be accessed
 * in block io mode.  
 * -------------------------------------------------------------------------- */
   
CLI typedef enum {
  BX_BIO_UNKNOWN,
  BX_BIO_TRACEMEM,
  BX_BIO_DATA_MEM,
  BX_BIO_CPU_PORT0,
  BX_BIO_CPU_PORT1
} bx_blockiorestype;

#ifndef SWIG
/* Version information */
typedef struct 
{
  /* Do not change the order of these ! */
  char MajorVersion;
  char MinorVersion;
  char LevelVersion;
  char PatchVersion;
} bx_vertype;
#endif  


/* This is for initializing a variable of the above type.
   The parameter is a #define containing a comma-separated 
   list of 4 version-numbers (see xversion.h)
 */

#define BX_VER_INIT(version)   {version}

#define BX_VER_NUMBER(versiontypeptr) \
         ((versiontypeptr)->PatchVersion<<0 | \
          (versiontypeptr)->LevelVersion<<8 | \
          (versiontypeptr)->MinorVersion<<16| \
          (versiontypeptr)->MajorVersion<<24)

#endif


